video.enablePostProcessing(4)

SHADERS = {}
PP_SHADERS = {}

function createShaderMaterial(shader)
	if _config.pixelShaders and shader and not shader.material then
		local vShader = shader.materialDef.vertexShader or "shaders/baseVertexCG.vsh"
		local pShader = shader.materialDef.pixelShader
		local baseType = shader.materialDef.baseMaterial or 12
		shader.material = video.createCgShader(vShader, pShader, baseType) or -1
	end
end

function setRenderShader(shader, shaderData)
	if _config.pixelShaders and shader then
		createShaderMaterial(shader)
		if shader.material > 0 then
			local data = shaderData or shader.defaultData
			video.setFileMaterial(shader.material, data.toShader)
			video.setUseMaterialFor2d(true)
		end
	end
end

function unsetRenderShader(shader, shaderData)
	if _config.pixelShaders and shader then
		video.setUseMaterialFor2d(false)
	end
end

function applyShader(object, shader, replaceParams)
	if _config.pixelShaders then
		object.shader = shader

		-- copy shader data
		if shader.defaultData then
			object.shaderData = table.copy(shader.defaultData)
		else
			object.shaderData = shader.staticData
		end
		-- replace parameters
		if replaceParams then
			for name,value in pairs(replaceParams) do
				object.shaderData[name] = value
			end
		end
	end
end

function getPPMaterial(shader)
	if _config.pixelShaders and shader then
		if not shader.material then
			local vShader = shader.materialDef.vertexShader or "shaders/pp.vsh"
			local pShader = shader.materialDef.pixelShader
			local baseType = shader.materialDef.baseMaterial or 12
			shader.material = video.createCgShader(vShader, pShader, baseType) or -1
		end
		return shader.material
	end
	return -1
end


PP_SHADERS.light = {
	materialDef = { pixelShader = "shaders/lightGradedPP.psh" },
	toShader = { intensity = 1, colorMask = {1, 1, 1, 1}},
}

PP_SHADERS.overlayLight = {
	materialDef = { pixelShader = "shaders/overlayLightGradedPP.psh" },
	toShader = { intensity = 1, colorMask = {1, 1, 1, 1}},
}

for i, def in pairs(PP_SHADERS) do
	def.index = i
end

for i, def in pairs(SHADERS) do
	def.index = i
end


--PP_SHADERS.damage = {
--	materialDef = { pixelShader = "shaders/damagePP.psh" },
--	toShader = { intensity = 1, brightness = 1, },
--}

